package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.VfichaOs3;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * VfichaOs3DaoImpl generated by UDA, 26-jun-2017 14:21:02.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class VfichaOs3DaoImpl implements VfichaOs3Dao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<VfichaOs3> rwMap = new RowMapper<VfichaOs3>() {
		public VfichaOs3 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new VfichaOs3(resultSet.getString("NUMEXPEDIENTE"),
					resultSet.getString("DECLARANTE"),
					resultSet.getString("ENCALIDADDE"),
					resultSet.getString("NOMBREEMPRESA"),
					resultSet.getString("EMPRESANOEXISTENTE"),
					resultSet.getString("EMPRESAEXISTENTE"),
					resultSet.getString("NUMERODOCUMENTOEMPRESA"),
					resultSet.getString("NUMEROAPERTURA"),
					resultSet.getString("RAZONSOCIALEMPRESA"),
					resultSet.getString("DIRECCIONEMPRESA"),
					resultSet.getString("MUNICIPIOEMPRESA"),
					resultSet.getString("TERRITORIOEMPRESA"),
					resultSet.getString("CPEMPRESA"),
					resultSet.getString("TELEFONOEMPRESA"),
					resultSet.getString("EMAEMPRESA"),
					resultSet.getString("HTTPEMPRESA"),
					resultSet.getString("FAXEMPRESA"),
					resultSet.getString("CLASECENTROTRABAJO"),
					resultSet.getLong("PLANTILLATOTALEMPRESA"),
					resultSet.getDate("FECHAEVALUACIONRIESGOS"),
					resultSet.getString("RIESGOSEXISTENTES"),
					resultSet.getString("ACTIVIDADPREVENTIVA"));
		}
	};

	private RowMapper<VfichaOs3> rwMapPK = new RowMapper<VfichaOs3>() {
		public VfichaOs3 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new VfichaOs3(resultSet.getString("NUMEXPEDIENTE"),
					resultSet.getString("DECLARANTE"),
					resultSet.getString("ENCALIDADDE"),
					resultSet.getString("NOMBREEMPRESA"),
					resultSet.getString("EMPRESANOEXISTENTE"),
					resultSet.getString("EMPRESAEXISTENTE"),
					resultSet.getString("NUMERODOCUMENTOEMPRESA"),
					resultSet.getString("NUMEROAPERTURA"),
					resultSet.getString("RAZONSOCIALEMPRESA"),
					resultSet.getString("DIRECCIONEMPRESA"),
					resultSet.getString("MUNICIPIOEMPRESA"),
					resultSet.getString("TERRITORIOEMPRESA"),
					resultSet.getString("CPEMPRESA"),
					resultSet.getString("TELEFONOEMPRESA"),
					resultSet.getString("EMAEMPRESA"),
					resultSet.getString("HTTPEMPRESA"),
					resultSet.getString("FAXEMPRESA"),
					resultSet.getString("CLASECENTROTRABAJO"),
					resultSet.getLong("PLANTILLATOTALEMPRESA"),
					resultSet.getDate("FECHAEVALUACIONRIESGOS"),
					resultSet.getString("RIESGOSEXISTENTES"),
					resultSet.getString("ACTIVIDADPREVENTIVA"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the VfichaOs3 table.
	 * 
	 *  vfichaos3
	 *            VfichaOs3
	 *  VfichaOs3
	 *
	 * @param vfichaos3 the vfichaos 3
	 * @return the vficha os 3
	 */
	public VfichaOs3 add(VfichaOs3 vfichaos3) {
		String query = "INSERT INTO VFICHA_OS3 (NUMEXPEDIENTE, DECLARANTE, ENCALIDADDE, NOMBREEMPRESA, EMPRESANOEXISTENTE, EMPRESAEXISTENTE, NUMERODOCUMENTOEMPRESA, NUMEROAPERTURA, RAZONSOCIALEMPRESA, DIRECCIONEMPRESA, MUNICIPIOEMPRESA, TERRITORIOEMPRESA, CPEMPRESA, TELEFONOEMPRESA, EMAEMPRESA, HTTPEMPRESA, FAXEMPRESA, CLASECENTROTRABAJO, PLANTILLATOTALEMPRESA, FECHAEVALUACIONRIESGOS, RIESGOSEXISTENTES, ACTIVIDADPREVENTIVA) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, vfichaos3.getNumexpediente(),
				vfichaos3.getDeclarante(), vfichaos3.getEncalidadde(),
				vfichaos3.getNombreempresa(),
				vfichaos3.getEmpresanoexistente(),
				vfichaos3.getEmpresaexistente(),
				vfichaos3.getNumerodocumentoempresa(),
				vfichaos3.getNumeroapertura(),
				vfichaos3.getRazonsocialempresa(),
				vfichaos3.getDireccionempresa(),
				vfichaos3.getMunicipioempresa(),
				vfichaos3.getTerritorioempresa(), vfichaos3.getCpempresa(),
				vfichaos3.getTelefonoempresa(), vfichaos3.getEmaempresa(),
				vfichaos3.getHttpempresa(), vfichaos3.getFaxempresa(),
				vfichaos3.getClasecentrotrabajo(),
				vfichaos3.getPlantillatotalempresa(),
				vfichaos3.getFechaevaluacionriesgos(),
				vfichaos3.getRiesgosexistentes(),
				vfichaos3.getActividadpreventiva());
		return vfichaos3;
	}

	/**
	 * Updates a single row in the VfichaOs3 table.
	 * 
	 *  vfichaos3
	 *            VfichaOs3
	 *  VfichaOs3
	 *
	 * @param vfichaos3 the vfichaos 3
	 * @return the vficha os 3
	 */
	public VfichaOs3 update(VfichaOs3 vfichaos3) {
		String query = "UPDATE VFICHA_OS3 SET  WHERE NUMEXPEDIENTE=? AND DECLARANTE=? AND ENCALIDADDE=? AND NOMBREEMPRESA=? AND EMPRESANOEXISTENTE=? AND EMPRESAEXISTENTE=? AND NUMERODOCUMENTOEMPRESA=? AND NUMEROAPERTURA=? AND RAZONSOCIALEMPRESA=? AND DIRECCIONEMPRESA=? AND MUNICIPIOEMPRESA=? AND TERRITORIOEMPRESA=? AND CPEMPRESA=? AND TELEFONOEMPRESA=? AND EMAEMPRESA=? AND HTTPEMPRESA=? AND FAXEMPRESA=? AND CLASECENTROTRABAJO=? AND PLANTILLATOTALEMPRESA=? AND FECHAEVALUACIONRIESGOS=? AND RIESGOSEXISTENTES=? AND ACTIVIDADPREVENTIVA=?";
		this.jdbcTemplate.update(query, vfichaos3.getNumexpediente(),
				vfichaos3.getDeclarante(), vfichaos3.getEncalidadde(),
				vfichaos3.getNombreempresa(),
				vfichaos3.getEmpresanoexistente(),
				vfichaos3.getEmpresaexistente(),
				vfichaos3.getNumerodocumentoempresa(),
				vfichaos3.getNumeroapertura(),
				vfichaos3.getRazonsocialempresa(),
				vfichaos3.getDireccionempresa(),
				vfichaos3.getMunicipioempresa(),
				vfichaos3.getTerritorioempresa(), vfichaos3.getCpempresa(),
				vfichaos3.getTelefonoempresa(), vfichaos3.getEmaempresa(),
				vfichaos3.getHttpempresa(), vfichaos3.getFaxempresa(),
				vfichaos3.getClasecentrotrabajo(),
				vfichaos3.getPlantillatotalempresa(),
				vfichaos3.getFechaevaluacionriesgos(),
				vfichaos3.getRiesgosexistentes(),
				vfichaos3.getActividadpreventiva());
		return vfichaos3;
	}

	/**
	 * Finds a single row in the VfichaOs3 table.
	 * 
	 *  vfichaos3
	 *            VfichaOs3
	 *  VfichaOs3
	 *
	 * @param vfichaos3 the vfichaos 3
	 * @return the vficha os 3
	 */
	@Transactional(readOnly = true)
	public VfichaOs3 find(VfichaOs3 vfichaos3) {
		String query = "SELECT t1.NUMEXPEDIENTE NUMEXPEDIENTE, t1.DECLARANTE DECLARANTE, t1.ENCALIDADDE ENCALIDADDE, t1.NOMBREEMPRESA NOMBREEMPRESA, t1.EMPRESANOEXISTENTE EMPRESANOEXISTENTE, t1.EMPRESAEXISTENTE EMPRESAEXISTENTE, t1.NUMERODOCUMENTOEMPRESA NUMERODOCUMENTOEMPRESA, t1.NUMEROAPERTURA NUMEROAPERTURA, t1.RAZONSOCIALEMPRESA RAZONSOCIALEMPRESA, t1.DIRECCIONEMPRESA DIRECCIONEMPRESA, t1.MUNICIPIOEMPRESA MUNICIPIOEMPRESA, t1.TERRITORIOEMPRESA TERRITORIOEMPRESA, t1.CPEMPRESA CPEMPRESA, t1.TELEFONOEMPRESA TELEFONOEMPRESA, t1.EMAEMPRESA EMAEMPRESA, t1.HTTPEMPRESA HTTPEMPRESA, t1.FAXEMPRESA FAXEMPRESA, t1.CLASECENTROTRABAJO CLASECENTROTRABAJO, t1.PLANTILLATOTALEMPRESA PLANTILLATOTALEMPRESA, t1.FECHAEVALUACIONRIESGOS FECHAEVALUACIONRIESGOS, t1.RIESGOSEXISTENTES RIESGOSEXISTENTES, t1.ACTIVIDADPREVENTIVA ACTIVIDADPREVENTIVA FROM VFICHA_OS3 t1  WHERE t1.NUMEXPEDIENTE = ?  ";

		List<VfichaOs3> vfichaos3List = this.jdbcTemplate.query(query,
				this.rwMap, vfichaos3.getNumexpediente());
		return (VfichaOs3) DataAccessUtils.uniqueResult(vfichaos3List);
	}

	/**
	 * Removes a single row in the VfichaOs3 table.
	 * 
	 *  vfichaos3            VfichaOs3
	 *
	 * @param vfichaos3 the vfichaos 3
	 */
	public void remove(VfichaOs3 vfichaos3) {
		String query = "DELETE FROM VFICHA_OS3 WHERE NUMEXPEDIENTE=? AND DECLARANTE=? AND ENCALIDADDE=? AND NOMBREEMPRESA=? AND EMPRESANOEXISTENTE=? AND EMPRESAEXISTENTE=? AND NUMERODOCUMENTOEMPRESA=? AND NUMEROAPERTURA=? AND RAZONSOCIALEMPRESA=? AND DIRECCIONEMPRESA=? AND MUNICIPIOEMPRESA=? AND TERRITORIOEMPRESA=? AND CPEMPRESA=? AND TELEFONOEMPRESA=? AND EMAEMPRESA=? AND HTTPEMPRESA=? AND FAXEMPRESA=? AND CLASECENTROTRABAJO=? AND PLANTILLATOTALEMPRESA=? AND FECHAEVALUACIONRIESGOS=? AND RIESGOSEXISTENTES=? AND ACTIVIDADPREVENTIVA=?";
		this.jdbcTemplate.update(query, vfichaos3.getNumexpediente(),
				vfichaos3.getDeclarante(), vfichaos3.getEncalidadde(),
				vfichaos3.getNombreempresa(),
				vfichaos3.getEmpresanoexistente(),
				vfichaos3.getEmpresaexistente(),
				vfichaos3.getNumerodocumentoempresa(),
				vfichaos3.getNumeroapertura(),
				vfichaos3.getRazonsocialempresa(),
				vfichaos3.getDireccionempresa(),
				vfichaos3.getMunicipioempresa(),
				vfichaos3.getTerritorioempresa(), vfichaos3.getCpempresa(),
				vfichaos3.getTelefonoempresa(), vfichaos3.getEmaempresa(),
				vfichaos3.getHttpempresa(), vfichaos3.getFaxempresa(),
				vfichaos3.getClasecentrotrabajo(),
				vfichaos3.getPlantillatotalempresa(),
				vfichaos3.getFechaevaluacionriesgos(),
				vfichaos3.getRiesgosexistentes(),
				vfichaos3.getActividadpreventiva());
	}

	/**
	 * Finds a list of rows in the VfichaOs3 table.
	 * 
	 *  vfichaos3
	 *            VfichaOs3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<VfichaOs3>
	 *
	 * @param vfichaos3 the vfichaos 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VfichaOs3> findAll(VfichaOs3 vfichaos3,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.NUMEXPEDIENTE NUMEXPEDIENTE,t1.DECLARANTE DECLARANTE,t1.ENCALIDADDE ENCALIDADDE,t1.NOMBREEMPRESA NOMBREEMPRESA,t1.EMPRESANOEXISTENTE EMPRESANOEXISTENTE,t1.EMPRESAEXISTENTE EMPRESAEXISTENTE,t1.NUMERODOCUMENTOEMPRESA NUMERODOCUMENTOEMPRESA,t1.NUMEROAPERTURA NUMEROAPERTURA,t1.RAZONSOCIALEMPRESA RAZONSOCIALEMPRESA,t1.DIRECCIONEMPRESA DIRECCIONEMPRESA,t1.MUNICIPIOEMPRESA MUNICIPIOEMPRESA,t1.TERRITORIOEMPRESA TERRITORIOEMPRESA,t1.CPEMPRESA CPEMPRESA,t1.TELEFONOEMPRESA TELEFONOEMPRESA,t1.EMAEMPRESA EMAEMPRESA,t1.HTTPEMPRESA HTTPEMPRESA,t1.FAXEMPRESA FAXEMPRESA,t1.CLASECENTROTRABAJO CLASECENTROTRABAJO,t1.PLANTILLATOTALEMPRESA PLANTILLATOTALEMPRESA,t1.FECHAEVALUACIONRIESGOS FECHAEVALUACIONRIESGOS,t1.RIESGOSEXISTENTES RIESGOSEXISTENTES,t1.ACTIVIDADPREVENTIVA ACTIVIDADPREVENTIVA ");
		query.append("FROM VFICHA_OS3 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vfichaos3);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<VfichaOs3>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the VfichaOs3 table using like.
	 * 
	 *  vfichaos3
	 *            VfichaOs3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<VfichaOs3>
	 *
	 * @param vfichaos3 the vfichaos 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VfichaOs3> findAllLike(VfichaOs3 vfichaos3,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.NUMEXPEDIENTE NUMEXPEDIENTE,t1.DECLARANTE DECLARANTE,t1.ENCALIDADDE ENCALIDADDE,t1.NOMBREEMPRESA NOMBREEMPRESA,t1.EMPRESANOEXISTENTE EMPRESANOEXISTENTE,t1.EMPRESAEXISTENTE EMPRESAEXISTENTE,t1.NUMERODOCUMENTOEMPRESA NUMERODOCUMENTOEMPRESA,t1.NUMEROAPERTURA NUMEROAPERTURA,t1.RAZONSOCIALEMPRESA RAZONSOCIALEMPRESA,t1.DIRECCIONEMPRESA DIRECCIONEMPRESA,t1.MUNICIPIOEMPRESA MUNICIPIOEMPRESA,t1.TERRITORIOEMPRESA TERRITORIOEMPRESA,t1.CPEMPRESA CPEMPRESA,t1.TELEFONOEMPRESA TELEFONOEMPRESA,t1.EMAEMPRESA EMAEMPRESA,t1.HTTPEMPRESA HTTPEMPRESA,t1.FAXEMPRESA FAXEMPRESA,t1.CLASECENTROTRABAJO CLASECENTROTRABAJO,t1.PLANTILLATOTALEMPRESA PLANTILLATOTALEMPRESA,t1.FECHAEVALUACIONRIESGOS FECHAEVALUACIONRIESGOS,t1.RIESGOSEXISTENTES RIESGOSEXISTENTES,t1.ACTIVIDADPREVENTIVA ACTIVIDADPREVENTIVA ");
		query.append("FROM VFICHA_OS3 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vfichaos3, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<VfichaOs3>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the VfichaOs3 table.
	 * 
	 *  vfichaos3
	 *            VfichaOs3
	 *  Long
	 *
	 * @param vfichaos3 the vfichaos 3
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(VfichaOs3 vfichaos3) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VFICHA_OS3 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vfichaos3);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the VfichaOs3 table using like.
	 * 
	 *  vfichaos3
	 *            VfichaOs3
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param vfichaos3 the vfichaos 3
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(VfichaOs3 vfichaos3, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VFICHA_OS3 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vfichaos3, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of VfichaOs3 selected for rup_table.
	 * 
	 *  vfichaos3            VfichaOs3
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<VfichaOs3>>
	 *
	 * @param vfichaos3 the vfichaos 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VfichaOs3>> reorderSelection(VfichaOs3 vfichaos3,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.NUMEXPEDIENTE NUMEXPEDIENTE,t1.DECLARANTE DECLARANTE,t1.ENCALIDADDE ENCALIDADDE,t1.NOMBREEMPRESA NOMBREEMPRESA,t1.EMPRESANOEXISTENTE EMPRESANOEXISTENTE,t1.EMPRESAEXISTENTE EMPRESAEXISTENTE,t1.NUMERODOCUMENTOEMPRESA NUMERODOCUMENTOEMPRESA,t1.NUMEROAPERTURA NUMEROAPERTURA,t1.RAZONSOCIALEMPRESA RAZONSOCIALEMPRESA,t1.DIRECCIONEMPRESA DIRECCIONEMPRESA,t1.MUNICIPIOEMPRESA MUNICIPIOEMPRESA,t1.TERRITORIOEMPRESA TERRITORIOEMPRESA,t1.CPEMPRESA CPEMPRESA,t1.TELEFONOEMPRESA TELEFONOEMPRESA,t1.EMAEMPRESA EMAEMPRESA,t1.HTTPEMPRESA HTTPEMPRESA,t1.FAXEMPRESA FAXEMPRESA,t1.CLASECENTROTRABAJO CLASECENTROTRABAJO,t1.PLANTILLATOTALEMPRESA PLANTILLATOTALEMPRESA,t1.FECHAEVALUACIONRIESGOS FECHAEVALUACIONRIESGOS,t1.RIESGOSEXISTENTES RIESGOSEXISTENTES,t1.ACTIVIDADPREVENTIVA ACTIVIDADPREVENTIVA ");
		// FROM
		query.append("FROM VFICHA_OS3 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vfichaos3, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager
				.getReorderQuery(
						query,
						jqGridRequestDto,
						VfichaOs3.class,
						filterParamList,
						"NUMEXPEDIENTE,DECLARANTE,ENCALIDADDE,NOMBREEMPRESA,EMPRESANOEXISTENTE,EMPRESAEXISTENTE,NUMERODOCUMENTOEMPRESA,NUMEROAPERTURA,RAZONSOCIALEMPRESA,DIRECCIONEMPRESA,MUNICIPIOEMPRESA,TERRITORIOEMPRESA,CPEMPRESA,TELEFONOEMPRESA,EMAEMPRESA,HTTPEMPRESA,FAXEMPRESA,CLASECENTROTRABAJO,PLANTILLATOTALEMPRESA,FECHAEVALUACIONRIESGOS,RIESGOSEXISTENTES,ACTIVIDADPREVENTIVA");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<VfichaOs3>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 *  filterParams            VfichaOs3
	 *  searchParams            VfichaOs3
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<VfichaOs3>>
	 *
	 * @param filterParams the filter params
	 * @param searchParams the search params
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VfichaOs3>> search(VfichaOs3 filterParams,
			VfichaOs3 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.NUMEXPEDIENTE NUMEXPEDIENTE,t1.DECLARANTE DECLARANTE,t1.ENCALIDADDE ENCALIDADDE,t1.NOMBREEMPRESA NOMBREEMPRESA,t1.EMPRESANOEXISTENTE EMPRESANOEXISTENTE,t1.EMPRESAEXISTENTE EMPRESAEXISTENTE,t1.NUMERODOCUMENTOEMPRESA NUMERODOCUMENTOEMPRESA,t1.NUMEROAPERTURA NUMEROAPERTURA,t1.RAZONSOCIALEMPRESA RAZONSOCIALEMPRESA,t1.DIRECCIONEMPRESA DIRECCIONEMPRESA,t1.MUNICIPIOEMPRESA MUNICIPIOEMPRESA,t1.TERRITORIOEMPRESA TERRITORIOEMPRESA,t1.CPEMPRESA CPEMPRESA,t1.TELEFONOEMPRESA TELEFONOEMPRESA,t1.EMAEMPRESA EMAEMPRESA,t1.HTTPEMPRESA HTTPEMPRESA,t1.FAXEMPRESA FAXEMPRESA,t1.CLASECENTROTRABAJO CLASECENTROTRABAJO,t1.PLANTILLATOTALEMPRESA PLANTILLATOTALEMPRESA,t1.FECHAEVALUACIONRIESGOS FECHAEVALUACIONRIESGOS,t1.RIESGOSEXISTENTES RIESGOSEXISTENTES,t1.ACTIVIDADPREVENTIVA ACTIVIDADPREVENTIVA ");
		// FROM
		query.append("FROM VFICHA_OS3 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager
				.getSearchQuery(
						query,
						jqGridRequestDto,
						VfichaOs3.class,
						filterParamList,
						searchSQL,
						searchParamList,
						from_alias,
						"NUMEXPEDIENTE,DECLARANTE,ENCALIDADDE,NOMBREEMPRESA,EMPRESANOEXISTENTE,EMPRESAEXISTENTE,NUMERODOCUMENTOEMPRESA,NUMEROAPERTURA,RAZONSOCIALEMPRESA,DIRECCIONEMPRESA,MUNICIPIOEMPRESA,TERRITORIOEMPRESA,CPEMPRESA,TELEFONOEMPRESA,EMAEMPRESA,HTTPEMPRESA,FAXEMPRESA,CLASECENTROTRABAJO,PLANTILLATOTALEMPRESA,FECHAEVALUACIONRIESGOS,RIESGOSEXISTENTES,ACTIVIDADPREVENTIVA");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<VfichaOs3>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 *  filtervfichaos3            VfichaOs3
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *
	 * @param filtervfichaos3 the filtervfichaos 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	@Override
	public void removeMultiple(VfichaOs3 filtervfichaos3,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.NUMEXPEDIENTE NUMEXPEDIENTE,t1.DECLARANTE DECLARANTE,t1.ENCALIDADDE ENCALIDADDE,t1.NOMBREEMPRESA NOMBREEMPRESA,t1.EMPRESANOEXISTENTE EMPRESANOEXISTENTE,t1.EMPRESAEXISTENTE EMPRESAEXISTENTE,t1.NUMERODOCUMENTOEMPRESA NUMERODOCUMENTOEMPRESA,t1.NUMEROAPERTURA NUMEROAPERTURA,t1.RAZONSOCIALEMPRESA RAZONSOCIALEMPRESA,t1.DIRECCIONEMPRESA DIRECCIONEMPRESA,t1.MUNICIPIOEMPRESA MUNICIPIOEMPRESA,t1.TERRITORIOEMPRESA TERRITORIOEMPRESA,t1.CPEMPRESA CPEMPRESA,t1.TELEFONOEMPRESA TELEFONOEMPRESA,t1.EMAEMPRESA EMAEMPRESA,t1.HTTPEMPRESA HTTPEMPRESA,t1.FAXEMPRESA FAXEMPRESA,t1.CLASECENTROTRABAJO CLASECENTROTRABAJO,t1.PLANTILLATOTALEMPRESA PLANTILLATOTALEMPRESA,t1.FECHAEVALUACIONRIESGOS FECHAEVALUACIONRIESGOS,t1.RIESGOSEXISTENTES RIESGOSEXISTENTES,t1.ACTIVIDADPREVENTIVA ACTIVIDADPREVENTIVA ");
		// FROM
		query.append("FROM VFICHA_OS3 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filtervfichaos3,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(
						jqGridRequestDto,
						VfichaOs3.class,
						query,
						params,
						"NUMEXPEDIENTE,DECLARANTE,ENCALIDADDE,NOMBREEMPRESA,EMPRESANOEXISTENTE,EMPRESAEXISTENTE,NUMERODOCUMENTOEMPRESA,NUMEROAPERTURA,RAZONSOCIALEMPRESA,DIRECCIONEMPRESA,MUNICIPIOEMPRESA,TERRITORIOEMPRESA,CPEMPRESA,TELEFONOEMPRESA,EMAEMPRESA,HTTPEMPRESA,FAXEMPRESA,CLASECENTROTRABAJO,PLANTILLATOTALEMPRESA,FECHAEVALUACIONRIESGOS,RIESGOSEXISTENTES,ACTIVIDADPREVENTIVA");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VfichaOs3 entity.
	 * 
	 *  vfichaos3            VfichaOs3 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param vfichaos3 the vfichaos 3
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(VfichaOs3 vfichaos3) {

		StringBuilder where = new StringBuilder(
				VfichaOs3DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (vfichaos3 != null && vfichaos3.getNumexpediente() != null) {
			where.append(" AND t1.NUMEXPEDIENTE = ?");
			params.add(vfichaos3.getNumexpediente());
		}
		if (vfichaos3 != null && vfichaos3.getDeclarante() != null) {
			where.append(" AND t1.DECLARANTE = ?");
			params.add(vfichaos3.getDeclarante());
		}
		if (vfichaos3 != null && vfichaos3.getEncalidadde() != null) {
			where.append(" AND t1.ENCALIDADDE = ?");
			params.add(vfichaos3.getEncalidadde());
		}
		if (vfichaos3 != null && vfichaos3.getNombreempresa() != null) {
			where.append(" AND t1.NOMBREEMPRESA = ?");
			params.add(vfichaos3.getNombreempresa());
		}
		if (vfichaos3 != null && vfichaos3.getEmpresanoexistente() != null) {
			where.append(" AND t1.EMPRESANOEXISTENTE = ?");
			params.add(vfichaos3.getEmpresanoexistente());
		}
		if (vfichaos3 != null && vfichaos3.getEmpresaexistente() != null) {
			where.append(" AND t1.EMPRESAEXISTENTE = ?");
			params.add(vfichaos3.getEmpresaexistente());
		}
		if (vfichaos3 != null && vfichaos3.getNumerodocumentoempresa() != null) {
			where.append(" AND t1.NUMERODOCUMENTOEMPRESA = ?");
			params.add(vfichaos3.getNumerodocumentoempresa());
		}
		if (vfichaos3 != null && vfichaos3.getNumeroapertura() != null) {
			where.append(" AND t1.NUMEROAPERTURA = ?");
			params.add(vfichaos3.getNumeroapertura());
		}
		if (vfichaos3 != null && vfichaos3.getRazonsocialempresa() != null) {
			where.append(" AND t1.RAZONSOCIALEMPRESA = ?");
			params.add(vfichaos3.getRazonsocialempresa());
		}
		if (vfichaos3 != null && vfichaos3.getDireccionempresa() != null) {
			where.append(" AND t1.DIRECCIONEMPRESA = ?");
			params.add(vfichaos3.getDireccionempresa());
		}
		if (vfichaos3 != null && vfichaos3.getMunicipioempresa() != null) {
			where.append(" AND t1.MUNICIPIOEMPRESA = ?");
			params.add(vfichaos3.getMunicipioempresa());
		}
		if (vfichaos3 != null && vfichaos3.getTerritorioempresa() != null) {
			where.append(" AND t1.TERRITORIOEMPRESA = ?");
			params.add(vfichaos3.getTerritorioempresa());
		}
		if (vfichaos3 != null && vfichaos3.getCpempresa() != null) {
			where.append(" AND t1.CPEMPRESA = ?");
			params.add(vfichaos3.getCpempresa());
		}
		if (vfichaos3 != null && vfichaos3.getTelefonoempresa() != null) {
			where.append(" AND t1.TELEFONOEMPRESA = ?");
			params.add(vfichaos3.getTelefonoempresa());
		}
		if (vfichaos3 != null && vfichaos3.getEmaempresa() != null) {
			where.append(" AND t1.EMAEMPRESA = ?");
			params.add(vfichaos3.getEmaempresa());
		}
		if (vfichaos3 != null && vfichaos3.getHttpempresa() != null) {
			where.append(" AND t1.HTTPEMPRESA = ?");
			params.add(vfichaos3.getHttpempresa());
		}
		if (vfichaos3 != null && vfichaos3.getFaxempresa() != null) {
			where.append(" AND t1.FAXEMPRESA = ?");
			params.add(vfichaos3.getFaxempresa());
		}
		if (vfichaos3 != null && vfichaos3.getClasecentrotrabajo() != null) {
			where.append(" AND t1.CLASECENTROTRABAJO = ?");
			params.add(vfichaos3.getClasecentrotrabajo());
		}
		if (vfichaos3 != null && vfichaos3.getPlantillatotalempresa() != null) {
			where.append(" AND t1.PLANTILLATOTALEMPRESA = ?");
			params.add(vfichaos3.getPlantillatotalempresa());
		}
		if (vfichaos3 != null && vfichaos3.getFechaevaluacionriesgos() != null) {
			where.append(" AND t1.FECHAEVALUACIONRIESGOS = ?");
			params.add(vfichaos3.getFechaevaluacionriesgos());
		}
		if (vfichaos3 != null && vfichaos3.getRiesgosexistentes() != null) {
			where.append(" AND t1.RIESGOSEXISTENTES = ?");
			params.add(vfichaos3.getRiesgosexistentes());
		}
		if (vfichaos3 != null && vfichaos3.getActividadpreventiva() != null) {
			where.append(" AND t1.ACTIVIDADPREVENTIVA = ?");
			params.add(vfichaos3.getActividadpreventiva());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VfichaOs3 entity.
	 * 
	 *  vfichaos3            VfichaOs3 Bean with the criteria values to filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param vfichaos3 the vfichaos 3
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(VfichaOs3 vfichaos3,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				VfichaOs3DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (vfichaos3 != null && vfichaos3.getNumexpediente() != null) {
			where.append(" AND UPPER(t1.NUMEXPEDIENTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos3.getNumexpediente().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos3.getNumexpediente().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NUMEXPEDIENTE IS NOT NULL");
		}
		if (vfichaos3 != null && vfichaos3.getDeclarante() != null) {
			where.append(" AND UPPER(t1.DECLARANTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos3.getDeclarante().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos3.getDeclarante().toUpperCase() + "%");
			}
			where.append(" AND t1.DECLARANTE IS NOT NULL");
		}
		if (vfichaos3 != null && vfichaos3.getEncalidadde() != null) {
			where.append(" AND UPPER(t1.ENCALIDADDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos3.getEncalidadde().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos3.getEncalidadde().toUpperCase() + "%");
			}
			where.append(" AND t1.ENCALIDADDE IS NOT NULL");
		}
		if (vfichaos3 != null && vfichaos3.getNombreempresa() != null) {
			where.append(" AND UPPER(t1.NOMBREEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos3.getNombreempresa().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos3.getNombreempresa().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBREEMPRESA IS NOT NULL");
		}
		if (vfichaos3 != null && vfichaos3.getEmpresanoexistente() != null) {
			where.append(" AND UPPER(t1.EMPRESANOEXISTENTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos3.getEmpresanoexistente().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ vfichaos3.getEmpresanoexistente().toUpperCase() + "%");
			}
			where.append(" AND t1.EMPRESANOEXISTENTE IS NOT NULL");
		}
		if (vfichaos3 != null && vfichaos3.getEmpresaexistente() != null) {
			where.append(" AND UPPER(t1.EMPRESAEXISTENTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos3.getEmpresaexistente().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos3.getEmpresaexistente().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.EMPRESAEXISTENTE IS NOT NULL");
		}
		if (vfichaos3 != null && vfichaos3.getNumerodocumentoempresa() != null) {
			where.append(" AND UPPER(t1.NUMERODOCUMENTOEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos3.getNumerodocumentoempresa().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ vfichaos3.getNumerodocumentoempresa().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NUMERODOCUMENTOEMPRESA IS NOT NULL");
		}
		if (vfichaos3 != null && vfichaos3.getNumeroapertura() != null) {
			where.append(" AND UPPER(t1.NUMEROAPERTURA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos3.getNumeroapertura().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos3.getNumeroapertura().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NUMEROAPERTURA IS NOT NULL");
		}
		if (vfichaos3 != null && vfichaos3.getRazonsocialempresa() != null) {
			where.append(" AND UPPER(t1.RAZONSOCIALEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos3.getRazonsocialempresa().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ vfichaos3.getRazonsocialempresa().toUpperCase() + "%");
			}
			where.append(" AND t1.RAZONSOCIALEMPRESA IS NOT NULL");
		}
		if (vfichaos3 != null && vfichaos3.getDireccionempresa() != null) {
			where.append(" AND UPPER(t1.DIRECCIONEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos3.getDireccionempresa().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos3.getDireccionempresa().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DIRECCIONEMPRESA IS NOT NULL");
		}
		if (vfichaos3 != null && vfichaos3.getMunicipioempresa() != null) {
			where.append(" AND UPPER(t1.MUNICIPIOEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos3.getMunicipioempresa().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos3.getMunicipioempresa().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.MUNICIPIOEMPRESA IS NOT NULL");
		}
		if (vfichaos3 != null && vfichaos3.getTerritorioempresa() != null) {
			where.append(" AND UPPER(t1.TERRITORIOEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos3.getTerritorioempresa().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos3.getTerritorioempresa().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TERRITORIOEMPRESA IS NOT NULL");
		}
		if (vfichaos3 != null && vfichaos3.getCpempresa() != null) {
			where.append(" AND UPPER(t1.CPEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos3.getCpempresa().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos3.getCpempresa().toUpperCase() + "%");
			}
			where.append(" AND t1.CPEMPRESA IS NOT NULL");
		}
		if (vfichaos3 != null && vfichaos3.getTelefonoempresa() != null) {
			where.append(" AND UPPER(t1.TELEFONOEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos3.getTelefonoempresa().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos3.getTelefonoempresa().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TELEFONOEMPRESA IS NOT NULL");
		}
		if (vfichaos3 != null && vfichaos3.getEmaempresa() != null) {
			where.append(" AND UPPER(t1.EMAEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos3.getEmaempresa().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos3.getEmaempresa().toUpperCase() + "%");
			}
			where.append(" AND t1.EMAEMPRESA IS NOT NULL");
		}
		if (vfichaos3 != null && vfichaos3.getHttpempresa() != null) {
			where.append(" AND UPPER(t1.HTTPEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos3.getHttpempresa().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos3.getHttpempresa().toUpperCase() + "%");
			}
			where.append(" AND t1.HTTPEMPRESA IS NOT NULL");
		}
		if (vfichaos3 != null && vfichaos3.getFaxempresa() != null) {
			where.append(" AND UPPER(t1.FAXEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos3.getFaxempresa().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos3.getFaxempresa().toUpperCase() + "%");
			}
			where.append(" AND t1.FAXEMPRESA IS NOT NULL");
		}
		if (vfichaos3 != null && vfichaos3.getClasecentrotrabajo() != null) {
			where.append(" AND UPPER(t1.CLASECENTROTRABAJO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos3.getClasecentrotrabajo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ vfichaos3.getClasecentrotrabajo().toUpperCase() + "%");
			}
			where.append(" AND t1.CLASECENTROTRABAJO IS NOT NULL");
		}
		if (vfichaos3 != null && vfichaos3.getPlantillatotalempresa() != null) {
			where.append(" AND t1.PLANTILLATOTALEMPRESA = ?");
			params.add(vfichaos3.getPlantillatotalempresa());
		}
		if (vfichaos3 != null && vfichaos3.getFechaevaluacionriesgos() != null) {
			where.append(" AND t1.FECHAEVALUACIONRIESGOS = ?");
			params.add(vfichaos3.getFechaevaluacionriesgos());
		}
		if (vfichaos3 != null && vfichaos3.getRiesgosexistentes() != null) {
			where.append(" AND UPPER(t1.RIESGOSEXISTENTES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos3.getRiesgosexistentes().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos3.getRiesgosexistentes().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.RIESGOSEXISTENTES IS NOT NULL");
		}
		if (vfichaos3 != null && vfichaos3.getActividadpreventiva() != null) {
			where.append(" AND UPPER(t1.ACTIVIDADPREVENTIVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos3.getActividadpreventiva().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ vfichaos3.getActividadpreventiva().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ACTIVIDADPREVENTIVA IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
